
uniform float u_Elapsed;
uniform vec2 u_WindowSize; 
uniform sampler2D iChannel0;


#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define NUM_DRIPS 50

float Seed;

void srand (float t)
{
    Seed = 0.5 + (sin (t*59.0) + sin (t*73.0) + sin (t*97.0))/6.0;
}
    
float rand()
{
    Seed = 0.25 + 0.5*Seed + 0.25*sin (12345.0 * Seed);
    return Seed;
}

vec2 dripPos (float fTime, out float fAge)
{
    float t = floor (fTime*0.1);
    srand (t);
    fAge = fTime*0.1 - t;
    return vec2 (rand(), rand());
}

void main(void)
{
	vec2 vRel = gl_FragCoord.xy / iResolution.xy;

    float t = iGlobalTime;
    float fStep = 123.456;
    float fHeight = 0.5;
    
    for (int i = 0; i < NUM_DRIPS; i++)
    {
        float fAge;
        vec2 vRnd = dripPos (t, fAge);
        vec2 vD = vec2 (vRel - vRnd);
        float fD = sqrt (dot (vD, vD));

        float fDa = 10.0 * (fD - fAge + 0.6);

        fHeight += (1.0 - fAge) 
            * max (0.0, 1.0 - (fDa*fDa))
            * sin (fD*150.0 - fAge*80.0);
        
        t += fStep;
    }

    vRel.y -= sign (fHeight) * fHeight*fHeight;
    vec4 vTex = texture2D (iChannel0, vRel);

    if (fHeight < 0.0)
    {
        float p = -fHeight*0.8;
        float q = 1.0 - p;
        vTex.b = p + q*vTex.b;
        p = -fHeight*0.3;
        q = 1.0 - p;
        vTex.g = p + q*vTex.g;
    }
    
    gl_FragColor = vTex; 
}

